/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.fml.loading.FMLPaths;
import org.sinytra.connector.ConnectorUtil;
import org.slf4j.Logger;

public record ConnectorConfig(int version, List<String> hiddenMods, Multimap<String, String> globalModAliases) {
    public static final Codec<ConnectorConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.comapFlatMap(i -> i == 1 ? DataResult.success((Object)i) : DataResult.error(() -> "Unsupported \"version\", must be 1"), Function.identity()).optionalFieldOf("version").forGetter(c -> Optional.of(c.version())), (App)Codec.STRING.listOf().optionalFieldOf("hiddenMods").forGetter(c -> Optional.of(c.hiddenMods())), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.either((Codec)Codec.STRING.listOf(), (Codec)Codec.STRING).xmap(either -> (List)either.map(list -> list, List::of), list -> list.size() == 1 ? Either.right((Object)((String)list.get(0))) : Either.left((Object)list))).xmap(map -> {
        HashMultimap aliases = HashMultimap.create();
        map.forEach((arg_0, arg_1) -> ((Multimap)aliases).putAll(arg_0, arg_1));
        return aliases;
    }, multimap -> {
        HashMap map = new HashMap();
        multimap.asMap().forEach((key, val) -> map.put(key, List.copyOf(val)));
        return map;
    }).optionalFieldOf("globalModAliases", (Object)ImmutableMultimap.of()).forGetter(ConnectorConfig::globalModAliases)).apply((Applicative)instance, ConnectorConfig::new));
    private static final ConnectorConfig DEFAULT = new ConnectorConfig(1, List.of(), ConnectorUtil.DEFAULT_GLOBAL_MOD_ALIASES);
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Supplier<ConnectorConfig> INSTANCE = Suppliers.memoize(() -> {
        Path path = FMLPaths.CONFIGDIR.get().resolve("connector.json");
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                JsonElement element = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)DEFAULT).getOrThrow(false, s -> {});
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                Files.writeString(path, (CharSequence)gson.toJson(element), new OpenOption[0]);
                return DEFAULT;
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                ConnectorConfig connectorConfig = (ConnectorConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(false, s -> {})).getFirst();
                return connectorConfig;
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error loading Connector configuration", t);
        }
        return DEFAULT;
    });

    ConnectorConfig(Optional<Integer> version, Optional<List<String>> hiddenMods, Multimap<String, String> globalModAliases) {
        this(version.orElse(1), hiddenMods.orElseGet(List::of), globalModAliases);
    }
}

